package com.example.bytesbee.alphabets.activities.utils;

import static com.example.bytesbee.alphabets.activities.constants.IConstants.UNDERSCORE;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.SharedPreferences.Editor;

/**
 * @author Prashant
 * @company BytesBee
 * @link http://bytesbee.com/
 */
public class SessionManager {
    private static final String PREF_NAME = "BBAlphabetsV1";
    private static final String KEY_ALPHA_THEME = "alpha_theme";
    private static final String KEY_NUMBER_THEME = "number_theme";
    private static final String KEY_ON_OFF_SOUND = "onOffSound";
    private static final String KEY_ON_OFF_VIBRATE = "onOffVibrate";
    private static final String KEY_ON_OFF_RTL = "onOffRTL";

    private final SharedPreferences pref;

    public SessionManager(final Context context) {
        pref = context.getSharedPreferences(context.getPackageName() + PREF_NAME, 0);
    }

    public void setAlphaValue(final String value) {
        final Editor editor = pref.edit();
        editor.putString(KEY_ALPHA_THEME, value);
        editor.apply();
    }

    /*
     * @description Value -> Default, Picture, Puzzle, etc
     * */
    public String getAlphaValue() {
        return pref.getString(KEY_ALPHA_THEME, AlphaTheme.DEFAULT.getValue());
    }

    /*
     * Value -> default_, picture_, puzzle_, etc
     * */
    public String getAlphaType() {
        return pref.getString(KEY_ALPHA_THEME, AlphaTheme.DEFAULT.getValue()).toLowerCase() + UNDERSCORE;
    }

    public void setNumberValue(final String value) {
        final Editor editor = pref.edit();
        editor.putString(KEY_NUMBER_THEME, value);
        editor.apply();
    }

    /*
     * @description Value -> Default, Picture, Puzzle, etc
     * */
    public String getNumberValue() {
        return pref.getString(KEY_NUMBER_THEME, AlphaTheme.DEFAULT.getValue());
    }

    /*
     * Value -> default_, picture_, puzzle_, etc
     * */
    public String getNumberType() {
        return pref.getString(KEY_NUMBER_THEME, AlphaTheme.DEFAULT.getValue()).toLowerCase() + UNDERSCORE;
    }

    public void setOnOffSound(final boolean value) {
        final Editor editor = pref.edit();
        editor.putBoolean(KEY_ON_OFF_SOUND, value);
        editor.apply();
    }

    public boolean isSoundOn() {
        return pref.getBoolean(KEY_ON_OFF_SOUND, true);
    }

    public void setOnOffVibrate(final boolean value) {
        final Editor editor = pref.edit();
        editor.putBoolean(KEY_ON_OFF_VIBRATE, value);
        editor.apply();
    }

    public boolean isVibrateOn() {
        return pref.getBoolean(KEY_ON_OFF_VIBRATE, true);
    }

    public void setOnOffRTL(final boolean value) {
        final Editor editor = pref.edit();
        editor.putBoolean(KEY_ON_OFF_RTL, value);
        editor.apply();
    }

    public boolean isRTLOn() {
        return pref.getBoolean(KEY_ON_OFF_RTL, false);
    }

    public void clearAll() {
        final Editor editor = pref.edit();
        editor.clear();
        editor.apply();
    }
}
